import cv2
from srunner.autoagents.sensor_interface import SensorInterface, CallBack
from srunner.scenariomanager.carla_data_provider import CarlaDataProvider
class VideoRecorder:
    def __init__(self,
                 camera_transform,
                 logdir='./',
                 video_path='output.mp4'):
        self.camera_transform = camera_transform
        self.video_path = logdir + video_path
        self.sensor_interface = SensorInterface()
        self.sensor = None
        self.camera_width = 800
        self.camera_height = 600
        self.current_frame = None

    def record_frame(self):
        self.current_frame = self.sensor_interface.get_data()['spectator'][1][:,:,:3]
        self.video.write(self.current_frame)
        cv2.imwrite("output.jpg", self.current_frame)

    def save(self):
        # Save the frames as a video
        self.video.release()
        cv2.destroyAllWindows()
    
    def setup_sensors(self):
        bp_library = CarlaDataProvider.get_world().get_blueprint_library()
        bp = bp_library.find('sensor.camera.rgb')
        bp.set_attribute('image_size_x', str(self.camera_width))
        bp.set_attribute('image_size_y', str(self.camera_height))
        bp.set_attribute('fov', str(90))
        sensor = CarlaDataProvider.get_world().spawn_actor(bp, self.camera_transform)
        sensor.listen(CallBack('spectator', sensor, self.sensor_interface))
        self.sensor = sensor
        CarlaDataProvider.get_world().tick()
    
    def reset(self):
        self.destroy()
        self.setup_sensors()
        fourcc = cv2.VideoWriter_fourcc(*'XVID')
        self.video = cv2.VideoWriter(self.video_path, fourcc, 20.0, (self.camera_width, self.camera_height))
        self.current_frame = self.sensor_interface.get_data()['spectator'][1][:,:,:3]

    def destroy(self):
        if self.sensor is not None:
            self.sensor.stop()
            self.sensor.destroy()
        self.sensor = None
